% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.theta.given.mean.detection.prob.R
\name{calculate.theta.given.mean.detection.prob}
\alias{calculate.theta.given.mean.detection.prob}
\title{Function for internal use only.}
\usage{
calculate.theta.given.mean.detection.prob(detection.function, theta2, w,
  mean.detection.prob.value, stop = F)
}
\arguments{
\item{detection.function}{The detection function. Only "halfnormal" and "hazard" (hazard rate) are supported at present.}

\item{theta2}{The second detection parameter for the hazard rate model (the shape parameter). Not required for halfnormal.}

\item{w}{The maximum range of observation. Objects at distance greater than w from the observer are assumed to never be recorded.}

\item{mean.detection.prob.value}{The mean detection probability over the range of observation.}

\item{stop}{Set to T to open a browser window (for debugging purposes)}
}
\value{
The value of the first parameter of theta.
}
\description{
Calculates the value of the first element of the detection parameters theta based on a supplied value of the average detection rate.
Primarily for internal use.
}
\examples{
calculate.theta.given.mean.detection.prob(detection.function="hazard",theta2=2,w=1,
mean.detection.prob.value=0.6) # should equal 0.448
calculate.theta.given.mean.detection.prob(detection.function="halfnormal",w=1,
mean.detection.prob.value=0.6) # should equal 0.502
}
\references{
Buckland S, Anderson D, Burnham K, Laake J and Borchers D (2001). Introduction to Distance Sampling: Estimating Abundance of Biological Populations. Oxford: Oxford University Press.

Clark, R. G. (2016), "Statistical efficiency in distance sampling," PLoS One, forthcoming, www.plosone.org
}

