% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_post}
\alias{create_post}
\title{Create a new blog post}
\usage{
create_post(
  title,
  author = "auto",
  slug = "auto",
  date = Sys.Date(),
  date_prefix = date,
  draft = FALSE,
  edit = interactive()
)
}
\arguments{
\item{title}{Post title}

\item{author}{Post author. Automatically drawn from previous post if not provided.}

\item{slug}{Post slug (directory name). Automatically computed from title if not
provided.}

\item{date}{Post date (defaults to current date)}

\item{date_prefix}{Date prefix for post slug (preserves chronological order for posts
within the filesystem). Pass \code{NULL} for no date prefix.}

\item{draft}{Mark the post as a \code{draft} (don't include it in the article listing).}

\item{edit}{Open the post in an editor after creating it.}
}
\description{
Create a new blog post
}
\note{
This function must be called from with a working directory that is within
a Distill website.
}
\examples{
\dontrun{
library(distill)
create_post("My Post")
}

}
