% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_ExoticStatistics.R
\name{cdfAntiDeriv}
\alias{cdfAntiDeriv}
\title{Cumulative Distribution Function Anti-Derivative}
\usage{
cdfAntiDeriv(object, lower = NULL, upper = NULL)
}
\arguments{
\item{object}{Distribution.}

\item{lower}{lower limit for integration, default is infimum.}

\item{upper}{upper limit for integration, default is supremum.}
}
\value{
Antiderivative of the cdf evaluated between limits as a numeric.
}
\description{
The anti-derivative of the cumulative distribution function between given limits or
over the full support.
}
\details{
The cdf anti-derivative is defined by
\deqn{acdf(a, b) = \int_a^b F_X(x) dx}
where X is the distribution, \eqn{F_X} is the cdf of the distribution \eqn{X} and \eqn{a, b} are the limits of integration.

Can only be used after decorating with \code{\link{ExoticStatistics}}.
}
\section{R6 Usage}{
 $cdfAntiDeriv(lower = NULL, upper = NULL)
}

\seealso{
\code{\link{ExoticStatistics}} and \code{\link{decorate}}
}
