% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tukey.R
\name{Tukey}
\alias{Tukey}
\title{Create a Tukey distribution}
\usage{
Tukey(nmeans, df, nranges)
}
\arguments{
\item{nmeans}{Sample size for each range.}

\item{df}{Degrees of freedom.}

\item{nranges}{Number of groups being compared.}
}
\value{
A \code{Tukey} object.
}
\description{
Tukey's studentized range distribution, used for Tukey's
honestly significant differences test in ANOVA.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

\strong{Support}: \eqn{R^+}, the set of positive real numbers.

Other properties of Tukey's Studentized Range Distribution
are omitted, largely because the distribution is not fun
to work with.
}
\examples{

set.seed(27)

X <- Tukey(4L, 16L, 2L)
X

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
