% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquare.R
\name{random.ChiSquare}
\alias{random.ChiSquare}
\title{Draw a random sample from a chi square distribution}
\usage{
\method{random}{ChiSquare}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{ChiSquare} object created by a call to \code{\link[=ChiSquare]{ChiSquare()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from a chi square distribution
}
\examples{

set.seed(27)

X <- ChiSquare(5)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
