% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{parts}
\alias{parts}
\title{Plot time series counts or proportions as polygons}
\usage{
parts(
  x,
  b = NULL,
  ord = "up",
  prop = FALSE,
  plot = TRUE,
  col = NULL,
  xlim = NULL,
  border = NULL,
  ylim = c(0, 1),
  na.valid = FALSE,
  labs = TRUE,
  labs.args = NULL,
  vertical = FALSE
)
}
\arguments{
\item{x}{\code{(numeric)}: The independent variable through which the proportion is tracked. Identical entries are used to assess which values belong together to a set. Their values represent the x coordinate over the plot.}

\item{b}{(\code{character} or \code{factor}): A single vector with the category designations. This vector will be segmented using the entries of \code{x}.}

\item{ord}{\code{(character)}: The parameter of the variable order. Either \code{"up"} (increasing alphabetical order), \code{"down"} (decreasing alphabetical order) or the vector of categories in the desired order.}

\item{prop}{\code{(logical)}: Should the diagram show proportions (\code{TRUE}) or counts (\code{FALSE})?}

\item{plot}{\code{(logical)}: If set to \code{TRUE}, then the function will plot the output. If set to \code{FALSE}, then a matrix with the relevant values will be returned. This output is similar to the output of \code{\link[base]{table}}, but handles proportions instantly.}

\item{col}{\code{(character)}: The color of polygons, has to a be a vector with as many entries as there are categories in \code{b}. By default \code{(col=NULL)} this is grayscale.}

\item{xlim}{\code{(numeric)}: Two values, analogous to the \code{xlim} argument of \code{\link[graphics]{plot}}, and has to exceed the range of \code{x}. The polygons that represent non-zero values with the lowest and highest values of \code{x} will be extended to these \code{x} coordinates.}

\item{border}{\code{(character)}: The a single color of the polygon borders. By default (\code{border=NA}), no borders are drawn.}

\item{ylim}{\code{(numeric)}: If \code{prop=TRUE}, then the argument controls the position of the proportions in the plotting area (useful to show proportions as a sub plot in a plot). If \code{prop=FALSE}, then the entire plotting area will be shifted by a single \code{ylim} value.}

\item{na.valid}{\code{(logical)}: If \code{TRUE}, than the missing values will be treated as an independent category. Entries where \code{x} is \code{NA} will be omitted either way.}

\item{labs}{\code{(logical)}: Should the category names be plotted?}

\item{labs.args}{\code{(list)}: Arguments for the \code{\link[graphics]{text}} function. If one entry for each argument is provided, then it will be applied to all labels. If the number of elements in an argument equals the number of categories to be plotted, then one to one assignment will be used. For example, for 4 categories in total, if the \code{labs.args} \code{list} contains a \code{col} vector element with 4 values, see examples).}

\item{vertical}{\code{(logical)}: Horizontal or vertical plotting? If \code{FALSE}, the independent variable will be horizontal, if \code{TRUE}, the count/proportion variable will be horizontal. In the latter case \code{xlim} and \code{ylim} has reversed roles.}
}
\value{
The function has no return value.
}
\description{
This function plots the changing shares of categories in association with an independent variable.
}
\details{
This function is useful for displaying the changing proportions of a category as time progresses. Check out the examples for the most frequent implementations.

To be added: missing portions are omitted in this version, but should be represented as gaps in the polygons.
}
\examples{

# dummy examples 
  # independent variable
  slc<-c(rep(1, 5), rep(2,7), rep(3,6))

  # the categories as they change
  v1<-c("a", "a", "b", "c", "c") # 1
  v2<-c("a", "b", "b", "b", "c", "d", "d") # 2
  v3<-c("a", "a", "a", "c", "c", "d") #3
  va<-c(v1, v2,v3)

  # basic function
    plot(NULL, NULL, ylim=c(0,1), xlim=c(0.5, 3.5))
    parts(slc, va, prop=TRUE)
 
  # vertical plot
    plot(NULL, NULL, xlim=c(0,1), ylim=c(0.5, 3.5))
    parts(slc, va, col=c("red" ,"blue", "green", "orange"), xlim=c(0.5,3.5), 
      labs=TRUE, prop=TRUE, vertical=TRUE)

  # intensive argumentation
    plot(NULL, NULL, ylim=c(0,10), xlim=c(0.5, 3.5))
    parts(slc, va, ord=c("b", "c", "d", "a"), col=c("red" ,"blue", "green", "orange"), 
	  xlim=c(0.5,3.5), labs=TRUE, prop=FALSE, 
	  labs.args=list(cex=1.3, col=c("black", "orange", "red", "blue")))

  # just the values
    parts(slc, va, prop=TRUE,plot=FALSE)
	
# real example
  # the proportion of coral occurrences through time in terms of bathymetry
  data(corals)
  data(stages)

  # time scale plot
  tsplot(stages, shading="series", boxes="sys", xlim=c(250,0), 
    ylab="proportion of occurrences", ylim=c(0,1))
  
  # plot of proportions	
  cols <- c("#55555588","#88888888", "#BBBBBB88")
  types <- c("uk", "shal", "deep")
  
  parts(x=stages$mid[corals$stg], b=corals$bath, 
   ord=types, col=cols, prop=TRUE,border=NA, labs=FALSE)
   
  # legend
  legend("left", inset=c(0.1,0), legend=c("unknown", "shallow", "deep"), fill=cols, 
    bg="white", cex=1.4) 

}
