% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_temporal.R
\name{temp.beta}
\alias{temp.beta}
\title{Temporal beta diversity calculation for raster}
\usage{
temp.beta(bin1, bin2, tree, filename = NULL, cores = 1, ...)
}
\arguments{
\item{bin1}{A SpatRaster with presence-absence data (0 or 1)
for a set of species.}

\item{bin2}{A SpatRaster with presence-absence data (0 or 1)
for a set of species.}

\item{tree}{It can be a data frame with species traits or a
phylogenetic tree.}

\item{filename}{Character. Save results if a name is provided.}

\item{cores}{A positive integer. If cores > 1, a 'parallel'
package cluster with that many cores is created and used.}

\item{...}{Additional arguments to be passed passed down from
a calling function.}
}
\value{
A SpatRaster with beta results (total, replacement,
and richness differences).
}
\description{
Temporal beta diversity calculation for raster
}
\examples{
library(terra)
bin1 <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
bin2 <- terra::rast(system.file("extdata", "fut.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
tree <- ape::read.tree(system.file("extdata", "tree.tre",
package = "divraster"))
temp.beta(bin1, bin2)
temp.beta(bin1, bin2, traits)
temp.beta(bin1, bin2, tree)
}
