% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_criteria.R
\name{sub_criteria}
\alias{sub_criteria}
\alias{eval_sub_criteria}
\alias{eval_sub_criteria.sub_criteria}
\title{Sub-criteria}
\usage{
sub_criteria(
  ...,
  match_funcs = diyar::exact_match,
  equal_funcs = diyar::exact_match,
  operator = "or"
)

eval_sub_criteria(x, ...)

\method{eval_sub_criteria}{sub_criteria}(
  x,
  strata = seq_len(max(attr_eval(x))),
  index_record = c(TRUE, rep(FALSE, length(strata) - 1)),
  sn = seq_len(length(strata)),
  check_duplicates = TRUE,
  ...
)
}
\arguments{
\item{...}{\code{[atomic]}.. Attributes.}

\item{match_funcs}{\code{[function]}. User defined logical test for matches.}

\item{equal_funcs}{\code{[function]}. User defined logical test for identical record sets (all attributes of the same record).}

\item{operator}{\code{[character]}. Options are \code{"and"} or \code{"or"}.}

\item{x}{\code{[sub_criteria]}}

\item{strata}{\code{[integer]}. Subsets of the dataset}

\item{index_record}{\code{[logical]}. Represents the \code{y}-value of the \code{x}-\code{y} record pair to be compared.
See (\bold{\code{\link{predefined_tests}}}).}

\item{sn}{\code{[integer]} Unique index for each record.}

\item{check_duplicates}{\code{[logical]}. If \code{FALSE}, does not check duplicate values. The result of the initial check will be recycled.}
}
\value{
\code{sub_criteria}

\code{Logical}
}
\description{
Matching criteria for each iteration of \bold{\code{\link{links}}} and \bold{\code{\link{episodes}}}.
}
\details{
\bold{\code{sub_criteria()}} is the mechanism for providing matching criteria to an iteration of \bold{\code{links}} or \bold{\code{episodes}}.
It creates a \code{sub_criteria} class object which contains the attributes to be compared,
logical tests for the comparisons (see \bold{\code{\link{predefined_tests}}} for examples) and
another set of logical tests to determine identical records.

\emph{*Determining identical records reduces processing time.}
}
\examples{
# Sub-criteria
s_cri1 <- sub_criteria(c(30, 28, 40, 25, 25, 29, 27),
                       match_funcs = range_match)
s_cri2 <- sub_criteria(c(30, 28, 40, 25, 25, 29, 27),
                       match_funcs = exact_match)

# Nested sub-criteria
s_cri3 <- sub_criteria(s_cri1, s_cri2, operator = "or")
s_cri4 <- sub_criteria(s_cri1, s_cri3, operator = "and")

`eval_sub_criteria`
# 3 values
strata <- rep(1, 3)
index_record <- c(TRUE, FALSE, FALSE)
sn <- 1:3

# Test for a match in either attribute
sub_cri_1 <- sub_criteria(c(1, 1, 0), c(2, 1, 2))
eval_sub_criteria(sub_cri_1, strata, index_record, sn)

# Test for a match in both attributes
sub_cri_2 <- sub_criteria(c(1, 1, 0), c(2, 1, 2), operator = "and")
eval_sub_criteria(sub_cri_2, strata, index_record, sn)
}
\seealso{
\code{\link{predefined_tests}}, \code{\link{links}} and \code{\link{episodes}}
}
