% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning}
\alias{binning}
\title{Binning the Numeric Data}
\usage{
binning(x, nbins, type = c("quantile", "equal", "pretty", "kmeans", "bclust"),
  ordered = TRUE, labels = NULL)
}
\arguments{
\item{x}{numeric vector for binning.}

\item{nbins}{number of classes. required. if missing, nclass.Sturges is used.}

\item{type}{binning method. one of "quantile", "equal", "equal", "pretty", "kmeans", "bclust"
The "quantile" style provides quantile breaks.
The "equal" style divides the range of the variable into nbins parts.
The "pretty" style chooses a number of breaks not necessarily equal
to nbins using base::pretty function.
The "kmeans" style uses stats::kmeans function to generate the breaks.
The "bclust" style uses e1071::bclust function to generate the breaks using bagged clustering.
"kmeans" and "bclust" type logic was implemented by classInt::classIntervals function.}

\item{ordered}{whether to build an ordered factor or not.}

\item{labels}{the label names to use for each of the bins.}
}
\value{
An object of bins class.
Attributes of bins class is as follows.
\itemize{
\item type : binning type, "quantile", "equal", "pretty", "kmeans", "bclust".
\item breaks : the number of intervals into which x is to be cut.
\item levels : levels of binned value.
\item raw : raw data, x argument value.
}
}
\description{
The binning() converts a numeric variable to a categorization variable.
}
\details{
This function is useful when used with the mutate/transmute
function of the dplyr package.
}
\section{"bins" class attributes information}{

Attributes of the "bins" classs that is as follows.

\itemize{
\item class : "bins".
\item levels : factor or ordered factor levels
\item type : binning method
\item breaks : breaks for binning
\item raw : before the binned the raw data
}

See vignette("transformation") for an introduction to these concepts.
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA
# Binning the carat variable. default type argument is "quantile"
bin <- binning(carseats$Income)
# Print bins class object
bin
# Summarise bins class object
summary(bin)
# Plot bins class object
plot(bin)
# Using labels argument
bin <- binning(carseats$Income, nbins = 4,
              labels = c("LQ1", "UQ1", "LQ3", "UQ3"))
bin
# Using another type argument
bin <- binning(carseats$Income, nbins = 5, type = "equal")
bin
bin <- binning(carseats$Income, nbins = 5, type = "pretty")
bin
bin <- binning(carseats$Income, nbins = 5, type = "kmeans")
bin
bin <- binning(carseats$Income, nbins = 5, type = "bclust")
bin

# -------------------------
# Using pipes & dplyr
# -------------------------
library(dplyr)

carseats \%>\%
 mutate(Income_bin = binning(carseats$Income)) \%>\%
 group_by(ShelveLoc, Income_bin) \%>\%
 summarise(freq = n()) \%>\%
 arrange(desc(freq)) \%>\%
 head(10)
}
\seealso{
\code{\link{binning_by}}, \code{\link{print.bins}}, \code{\link{summary.bins}}.
}
