% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_by.R
\name{target_by}
\alias{target_by}
\alias{target_by.data.frame}
\title{Target by one variables}
\usage{
target_by(.data, target, ...)

\method{target_by}{data.frame}(.data, target, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{target}{target variable.}

\item{...}{arguments to be passed to methods.}
}
\value{
an object of target_df class.
Attributes of target_df class is as follows.
\itemize{
\item type_y : the data type of target variable.
}
}
\description{
In the data analysis, a target_df class is created to identify the
relationship between the target variable and the other variable.
}
\details{
Data analysis proceeds with the purpose of predicting target variables that
 correspond to the facts of interest, or examining associations and
 relationships with other variables of interest.
 Therefore, it is a major challenge for EDA to examine the relationship
 between the target variable and its corresponding variable.
 Based on the derived relationships, analysts create scenarios for data analysis.

 target_by() inherits the \code{\link{grouped_df}} class and returns a target_df
 class containing information about the target variable and the variable.

See vignette("EDA") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# If the target variable is a categorical variable
categ <- target_by(carseats, US)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, Sales)
cat_num
summary(cat_num)

# plot(cat_num)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, ShelveLoc)
cat_cat
summary(cat_cat)

# plot(cat_cat)

##---------------------------------------------------
# If the target variable is a categorical variable
num <- target_by(carseats, Sales)

# If the variable of interest is a numerical variable
num_num <- relate(num, Price)
num_num
summary(num_num)

# plot(num_num)

# If the variable of interest is a categorical variable
num_cat <- relate(num, ShelveLoc)
num_cat
summary(num_cat)

# plot(num_cat)

# Not allow typographic
# plot(num_cat, typographic = FALSE)

}
\seealso{
\code{\link{relate}}.
}
