% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasEquiv_EffectSize_Wrappers.R
\name{dmacs_summary_single}
\alias{dmacs_summary_single}
\title{Summary of measurement nonequivalence effects for a single group}
\usage{
dmacs_summary_single(LambdaR, ThreshR, LambdaF, ThreshF, MeanF, VarF, SD,
  categorical = FALSE, ...)
}
\arguments{
\item{LambdaR}{is the factor loading matrix (or dataframe) for the
reference group.}

\item{ThreshR}{is a vector of indicator intercepts (for continuous
indicators) or a list, indexed by items, of vectors of thresholds (for
categorical indicators) for the reference group. For categorical
indicators, do \strong{not} provide a matrix of thresholds.}

\item{LambdaF}{is the factor loading matrix (or dataframe) for the
focal group.}

\item{ThreshF}{is a  vector of indicator intercepts (for continuous
indicators) or a list, indexed by items, of vectors of thresholds (for
categorical indicators) for the focal group. For categorical indicators,
do \strong{not} provide a matrix of thresholds.}

\item{MeanF}{is a vector of factor means for the focal group}

\item{VarF}{is a vector of factor variances for the focal group.}

\item{SD}{is a vector of indicator observed standard deviations used as
the denominator of the dmacs effect size. This will usually either be
pooled standard deviations or the standard deviation of the reference
group.}

\item{categorical}{is a Boolean variable declaring whether the variables
in the model are ordered categorical. Models in which some variables are
categorical and others are continuous are not supported. If no value is
provided, categorical defaults to \code{FALSE}, although if multiple
thresholds are provided for an item, categorical will be forced to
\code{TRUE}. A graded response model with probit link (e.g., DWLS in
lavaan or WLSMV in Mplus) is used for categorical variables. If you desire
for other categorical models (e.g., IRT parameterization) to be supported,
e-mail the maintainer.}

\item{...}{other parameters to be used in functions that
\code{dmacs_summary_single} calls, most likely \code{stepsize} for the
\code{\link{item_dmacs}} and \code{\link{delta_mean_item}} functions.}
}
\value{
A list of measurement nonequivalence effects from Nye and Drasgow
(2011), including dmacs,
expected bias in the mean score by item, expected bias in the mean total
score, and expected bias in the variance of the total score. Expected bias
in the variance of the total score is only supplied for unidimensional
models in the current version of this package
}
\description{
\code{dmacs_summary_single} returns a summary of measurement non-equivalence
effects given parameters for a focal and reference group.
}
\details{
\code{dmacs_summary_single} is called by \code{dmacs_summary}, which
in turn is called by \code{\link{lavaan_dmacs}} and
\code{\link{mplus_dmacs}}, which are the only functions in this
package intended for casual users
}
\section{References}{

Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
measurement equivalence: Understanding the practical importance of
differences between groups. \emph{Journal of Applied Psychology, 96}(5),
966-980.
}

\examples{
LambdaF <- matrix(c(1.00, 0.74,  1.14, 0.92), ncol = 1)
LambdaR <- matrix(c(1.00, 0.76,  1.31, 0.98), ncol = 1)
ThreshF <- c(0.00, 1.28, -0.82, 0.44)
ThreshR <- c(0.00, 0.65, -0.77, 0.47)
MeanF   <- 0.21
VarF    <- 1.76
SD      <- c(2.12, 1.85,  1.12, 3.61)
dmacs_summary_single(LambdaR, ThreshR, LambdaF, ThreshF, MeanF, VarF, SD)

}
