% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R, R/validate.character.R,
%   R/validate.dmdSchemeSet_raw.R
\name{validate}
\alias{validate}
\alias{validate.character}
\alias{validate.dmdSchemeSet_raw}
\title{Generic function to validate an object which represents a \code{dmdScheme}}
\usage{
validate(x, path = ".", validateData = TRUE,
  errorIfStructFalse = TRUE)

\method{validate}{character}(x, path = ".", validateData = TRUE,
  errorIfStructFalse = TRUE)

\method{validate}{dmdSchemeSet_raw}(x, path = ".", validateData = TRUE,
  errorIfStructFalse = TRUE)
}
\arguments{
\item{x}{object referring to a \code{dmdScheme} to be validatedof class \code{dmdSchemeSet_raw} as returned from \code{read_excel( keepData = FALSE, raw = TRUE)} or file name of an xlsx file containing the metadata.}

\item{path}{path to the data files}

\item{validateData}{if \code{TRUE} data is validated as well; the structure is always validated}

\item{errorIfStructFalse}{if \code{TRUE} an error will be raised if the schemes are not identical, i.e. there are structural differences.}
}
\value{
return the \code{dmdScheme_validation} object
}
\description{
This function validates an object representing a \code{dmdScheme}.  The result can
be used as a basis for a report by running \code{report()} on the resultiung
object of class \code{dmdScheme_validation}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: validate a \code{character} object referring to a spreadsheet file which contains the metadata.

\item \code{dmdSchemeSet_raw}: validate a \code{dmdSchemeSet_raw} object
}}

\examples{
## validata an Excel file containing the metadata
validate(
    x = scheme_path_xlsx()
)

## validate a `dmdScheme_raw object`
validate(
   x = dmdScheme_raw()
)

## use `read_raw()` to read an Excel spreadsheet into a `dmdScheme_raw` object
x <- read_excel_raw( scheme_path_xlsx() )
validate( x = x )

}
