% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{summary.dnapath_list}
\alias{summary.dnapath_list}
\title{Summary function for 'dnapath_list' object.}
\usage{
\method{summary}{dnapath_list}(
  object,
  by_gene = FALSE,
  alpha_pathway = 1,
  alpha_gene = 0.1,
  monotonized = FALSE,
  ...
)
}
\arguments{
\item{object}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{by_gene}{If TRUE, summarizes the differential network analysis by genes
instead of by pathways.}

\item{alpha_pathway}{Threshold for p-values of pathway DC scores; used
to subset the results. If NULL (or 1), results for all pathways are shown.}

\item{alpha_gene}{Threshold for p-values of gene DC scores. Used to determine
the number of genes that are differentially connected within each pathway.
Defaults to 0.1 or the minimum possible threshold for the number
of permutations performed, whichever is greater.}

\item{monotonized}{If TRUE, monotonized p-values are used.}

\item{...}{Additional arguments are ignored.}
}
\value{
Summarizes the differential network analysis results.
}
\description{
Summary function for 'dnapath_list' object.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
summary(results) # Summary across all pathways in the analysis.
}
\seealso{
\code{\link{summarize_pathways}}, \code{\link{summarize_genes}}
}
