% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_list.R
\name{spell_list}
\alias{spell_list}
\title{List Spells Based on Criteria}
\usage{
spell_list(
  name = NULL,
  class = NULL,
  level = NULL,
  school = NULL,
  ritual = NULL,
  cast_time = NULL
)
}
\arguments{
\item{name}{(character) text to look for in spell names}

\item{class}{(character) character class(es) with the spell(s) on their list}

\item{level}{(character) "cantrip" and/or the minimum required spell slot level}

\item{school}{(character) school(s) of magic within which the spell belongs (e.g., 'evocation', 'necromancy', etc.)}

\item{ritual}{(logical) whether the spell can be cast as a ritual}

\item{cast_time}{(character) either the phase of a turn needed to cast the spell or the in-game time required (e.g., "reaction", "1 minute", etc.)}
}
\value{
(dataframe) 10 columns of information with one row per spell(s) that fit(s) the user-specified criteria. If no spells fit the criteria, returns a message to that effect instead of a data object
}
\description{
Query list of all Dungeons & Dragons spells based on partial string matches between user inputs and the relevant column of the spell information data table. Currently supports users querying the spell list by spell name, which class lists allow the spell, spell's level, the school of magic the spell belongs in, whether or not the spell can be cast as a ritual, and the time it takes to cast the spell. All character arguments are case-insensitive (note that the ritual argument expects a logical). Any argument set to `NULL` (the default) will not be used to include/exclude spells from the returned set of spells
}
\examples{
# Search for evocation spells with 'fire' in the name that a wizard can cast
spell_list(name = "fire", class = "wizard", school = "evocation")

}
