\name{dNetInduce}
\alias{dNetInduce}
\title{Function to generate a subgraph induced by given vertices and
their k nearest neighbors}
\usage{
dNetInduce(g, nodes_query, knn = 0, remove.loops = T,
largest.comp = T)
}
\arguments{
\item{g}{an object of class "igraph" or "graphNEL"}

\item{nodes_query}{the vertices for which the calculation
is performed}

\item{knn}{an integeter specifying how many k steps are
used to find the nearest neighbours of the given
vertices. By default, knn is set to zero; it means no
neighbors will be considered. When knn is 1, the
immediate neighbors of the given vertices will be also
considered for inducing the subgraph. The same is true
when knn is 2, etc}

\item{remove.loops}{logical to indicate whether the loop
edges are to be removed. By default, it sets to true for
self-loops being removed}

\item{largest.comp}{logical to indicate whether the
largest component is only retained. By default, it sets
to true for the largest component being left}
}
\value{
\itemize{ \item{\code{subg}: an induced subgraph, an
object of class "igraph" or "graphNEL"} }
}
\description{
\code{dNetInduce} is supposed to produce a subgraph
induced by given vertices and its k nearest neighbors.
The input is a graph of "igraph" or "graphNET" object, a
list of the vertices of the graph, and a k value for
finding k nearest neighbors for these vertices. The
output is a subgraph induced by given veretices plus
their k neighbours. The resultant subgraph inherits the
class from the input one. The induced subgraph conatins
exactly the vertices of interest, and all the edges
between them.
}
\note{
The given vertices plus their k nearest neighbors will be
used to induce the subgraph.
}
\examples{
# 1) generate a random graph according to the ER model
g <- erdos.renyi.game(100, 1/100)

# 2) select the frist 10 vertices as the query nodes
nodes_query <- V(g)[1:10]

# 3) produce the induced subgraph only based on the nodes in query
subg <- dNetInduce(g, nodes_query, knn=0)

# 4) produce the induced subgraph based on the nodes in query ane their immediate neighbours
subg <- dNetInduce(g, nodes_query, knn=1)
}
\seealso{
\code{\link{dNetInduce}}
}

