% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by-lapplyBy.R
\name{by-lapply}
\alias{by-lapply}
\alias{lapply_by}
\alias{lapplyBy}
\title{Formula based version of lapply.}
\usage{
lapply_by(data, formula, FUN = mean)

lapplyBy(formula, data = parent.frame(), FUN)
}
\arguments{
\item{data}{A dataframe.}

\item{formula}{A formula describing how data should be split.}

\item{FUN}{A function to be applied to each element in the splitted
list, see 'Examples' below.}
}
\value{
A list.
}
\description{
This function is a wrapper for calling lapply on the
    list resulting from first calling splitBy.
}
\examples{
data(dietox)

## Calculate weekwise feed efficiency = weight gain / feed intake
dietox <- orderBy(~Pig + Time, data=dietox)
v <- lapplyBy(~Pig, data=dietox,
              function(d) c(NA, diff(d$Weight) / diff(d$Feed)))
dietox$FE <- unlist(v)

## Technically this is the same as 
dietox <- orderBy(~Pig + Time, data=dietox)
wdata <- splitBy(~Pig, data=dietox)
v <- lapply(wdata, function(d) c(NA, diff(d$Weight)/diff(d$Feed)))
dietox$FE <- unlist(v)

}
\seealso{
\code{\link{lapplyBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
