% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_partition_unsup.R
\name{evaluate_partition_unsup}
\alias{evaluate_partition_unsup}
\title{Comparison of an unsupervised obtained partition to a reference partition.}
\usage{
evaluate_partition_unsup(
  partition,
  partition.ref,
  is.missing = NULL,
  is.cens = NULL
)
}
\arguments{
\item{partition}{vector (factor): the partition to evaluate.}

\item{partition.ref}{reference partition 1 (ex partition on complete data or
true partition if known).}

\item{is.missing}{boolean vector identifying observations with missing data
(coded \code{TRUE}), from those without (coded \code{FALSE}).}

\item{is.cens}{the incomplete dataframe with NA for missing and
left-censored data (or the complete datasets if all data were observed).}
}
\value{
A list containing the following elements : \code{Nbclust}: number of
clusters of the partition; \code{ARI}: ARI value on cases classified by
both partitions ;  \code{ARI.cc}: ARI value on cases complete AND
classified by both partitions ; \code{ARI.nona}; ARI on cases with no
missing data AND classified by both partitions; \code{ARI.nocens}: ARI on
cases with no censored data AND classified by both partitions ;
\code{Per.Unclass}: Percentage of observations unclassified in the
partition ; \code{Per.Unclass.cc}: Among complete cases, percentage of
observations unclassified in the partition ; \code{Per.Unclass.na}:
Among cases with missing data, percentage of observations unclassified in
the partition ; \code{Per.Unclass.cens}: Among cases with censored data,
percentage of observations unclassified in the partition ;
\code{Per.Unclass.ic}: Among incomplete cases, percentage of observations
unclassified in the partition
}
\description{
Compares partitions on number of cluster, ARI and percentage of unclassified
observations.
}
\examples{
res <- evaluate_partition_unsup(
  partition = factor(rep(c(1,2,3), each = 50)),
  partition.ref = factor(rep(c(1,2,3), times = c(100, 25, 25))))

## With missing data
res2 <- evaluate_partition_unsup(
  partition = factor(rep(c(1,2,3), each = 50)),
  partition.ref = factor(rep(c(1,2,3), times = c(100, 25, 25))),
  is.missing = sample(c(TRUE, FALSE), 150, replace = TRUE, prob = c(.2,.8)))

## With missing and censored data
  missing.indicator <- sample(c(TRUE, FALSE), 150,
   replace = TRUE, prob = c(.2,.8))
  Censor.indicator <- data.frame(
   X1 = runif(150, 1, 5),
   X2 = runif(150, 6, 8),
   X3 = runif(150, 3, 9))
  Censor.indicator$X1[missing.indicator] <- NA
  Censor.indicator$X1[
  sample(c(TRUE, FALSE), 150,replace = TRUE, prob = c(.1,.9))] <- NA
  Censor.indicator$X2[
  sample(c(TRUE, FALSE), 150,replace = TRUE, prob = c(.3,.7))] <- NA
  Censor.indicator$X3[
  sample(c(TRUE, FALSE), 150,replace = TRUE, prob = c(.05,.95))] <- NA
res3 <- evaluate_partition_unsup(
  partition = factor(rep(c(1,2,3), each = 50)),
  partition.ref = factor(rep(c(1,2,3), times = c(100, 25, 25))),
  is.missing = missing.indicator,
  is.cens = Censor.indicator)

## With missing and censored data and unclassifed observations
res4 <- evaluate_partition_unsup(
  partition = factor(rep(c(1,2, NA,3), times = c(50, 40, 20, 40))),
  partition.ref = factor(rep(c(1,2,3), times = c(100, 25, 25))),
  is.missing = missing.indicator,
  is.cens = Censor.indicator)
}
