% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paragraph2vec.R
\name{paragraph2vec_similarity}
\alias{paragraph2vec_similarity}
\title{Similarity between document / word vectors as used in paragraph2vec}
\usage{
paragraph2vec_similarity(x, y, top_n = +Inf)
}
\arguments{
\item{x}{a matrix with embeddings where the rownames of the matrix provide the label of the term}

\item{y}{a matrix with embeddings where the rownames of the matrix provide the label of the term}

\item{top_n}{integer indicating to return only the top n most similar terms from y for each row of x. 
If \code{top_n} is supplied, a data.frame will be returned with only the highest similarities between x and y 
instead of all pairwise similarities}
}
\value{
By default, the function returns a similarity matrix between the rows of \code{x} and the rows of \code{y}. 
The similarity between row i of \code{x} and row j of \code{y} is found in cell \code{[i, j]} of the returned similarity matrix.\cr
If \code{top_n} is provided, the return value is a data.frame with columns term1, term2, similarity and rank 
indicating the similarity between the provided terms in \code{x} and \code{y} 
ordered from high to low similarity and keeping only the top_n most similar records.
}
\description{
The similarity between document / word vectors is defined as the inner product of the vector elements
}
\examples{
x <- matrix(rnorm(6), nrow = 2, ncol = 3)
rownames(x) <- c("word1", "word2")
y <- matrix(rnorm(15), nrow = 5, ncol = 3)
rownames(y) <- c("doc1", "doc2", "doc3", "doc4", "doc5")

paragraph2vec_similarity(x, y)
paragraph2vec_similarity(x, y, top_n = 1)
paragraph2vec_similarity(x, y, top_n = 2)
paragraph2vec_similarity(x, y, top_n = +Inf)
paragraph2vec_similarity(y, y)
paragraph2vec_similarity(y, y, top_n = 1)
paragraph2vec_similarity(y, y, top_n = 2)
paragraph2vec_similarity(y, y, top_n = +Inf)
}
\seealso{
\code{\link{paragraph2vec}}
}
