% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetnet-fns.R
\name{weight_streetnet}
\alias{weight_streetnet}
\title{weight_streetnet}
\usage{
weight_streetnet(sf_lines, wt_profile = "bicycle")
}
\arguments{
\item{sf_lines}{A street network represented as \code{sf} \code{LINESTRING}
objects, typically extracted with \code{get_stretnet}}

\item{wt_profile}{Name of weighting profile}
}
\value{
A \code{data.frame} of edges representing the street network, along
with a column of graph component numbers.
}
\description{
Weight (or re-weight) an \code{sf}-formatted OSM street network according to
a named routino profile, selected from (foot, horse, wheelchair, bicycle,
moped, motorcycle, motorcar, goods, hgv, psv).
}
\examples{
net <- weight_streetnet (hampi) # internal sf-formatted street network
class(net) # data.frame
dim(net) # 6096  11; 6096 streets
}
