% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{area2d}
\alias{area2d}
\title{2D surface area}
\usage{
area2d(mesh, method = "concave")
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{method}{the method used to compute the hull of the 2d projection, either
'convex' (see \code{\link[grDevices]{chull}}),
or 'concave' (see \code{\link[concaveman]{concaveman}}). The default method is 'concave'.}
}
\value{
A single 2D surface area value, corresponding to the footprint of the mesh.
}
\description{
Compute the area of a 2d projection on the (xy) plane.
}
\examples{
#The following objects should have the exact same footprints:
area2d(dkmodel$basin)
area2d(dkmodel$complex)
area2d(dkmodel$cusp)
area2d(dkmodel$flat)

#Graphical rendering of convex hull
x <- dkmodel$cusp
FootprintVerts <- t(x$vb[1:2, ])
Hull <- grDevices::chull(x = FootprintVerts[, 1], y = FootprintVerts[, 2])
plot(x$vb[1, ], x$vb[2, ], xlab = "x", ylab = "y")
points(x$vb[1, Hull], x$vb[2, Hull], col = "orange1")

#Graphical rendering of concave hull
x <- dkmodel$cusp
FootprintVerts <- t(x$vb[1:2, ])
FootprintVerts[, 1] <- FootprintVerts[, 1] - min(FootprintVerts[, 1])
FootprintVerts[, 2] <- FootprintVerts[, 2] - min(FootprintVerts[, 2])
Hull <- concaveman::concaveman(points = FootprintVerts)
plot(x$vb[1, ] - min(x$vb[1, ]), x$vb[2, ] - min(x$vb[2, ]), xlab = "x", ylab = "y")
points(Hull, col = "green1")
}
\seealso{
\code{\link{rfi}}
}
