% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{extract_dose_unit}
\alias{extract_dose_unit}
\title{Extract units of dose from freetext prescriptions.}
\usage{
extract_dose_unit(txt)
}
\arguments{
\item{txt}{a character vector}
}
\value{
A character vector the same length as \code{txt}, containing
standardised units, or \code{NA} if no units were found in the prescription.

A simple wrapper around \code{\link[stringr:str_replace]{str_replace_all}} and
\code{\link[stringr]{str_extract}}.
Based on \code{add_dose_unit.py} from original Python/Java algorithm.
}
\description{
A function used internally in \code{\link{extract_from_prescription}} to
parse the dosage units, such as millilitres, tablets, grams and so on.
If there are multiple units mentioned in a string, only the first is returned.
}
\seealso{
\code{\link{extract_from_prescription}}
}
