% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dcca.R
\name{predict.dcca}
\alias{predict.dcca}
\title{Prediction for double-constrained correspondence analysis (dc-CA)}
\usage{
\method{predict}{dcca}(
  object,
  ...,
  type = c("env", "traits", "response", "reg_env", "reg_traits"),
  rank = "full",
  newdata = NULL
)
}
\arguments{
\item{object}{return value of \code{\link{dc_CA}}.}

\item{...}{Other arguments passed to the function (currently ignored).}

\item{type}{type of prediction, \code{c("env", "traits", "response", 
"reg_env", "reg_trait")} for environmental values, values of traits, 
response (expected abundance), regression coefficients for environmental 
and trait predictors.}

\item{rank}{rank or number of axes to use. Default "full" for all axes 
(no rank-reduction).}

\item{newdata}{Data in which to look for variables with which to predict.
For \code{type = "reg_env" or "reg_trait"} newdata is ignored. For 
\code{type = "env" or "trait"}, \code{newdata} is a data frame of trait and 
environmental values, respectively, which are used for the prediction. If 
omitted, fitted values are generated.
For \code{type = "response"}, newdata is a list of two data frames with 
trait and environmental values in this order, \emph{e.g.} 
\code{list(traits = dataTraits, env = dataEnv)}.}
}
\value{
a matrix with the predictions. The exact content of the matrix 
depends on the \code{type} of predictions that are being made.
}
\description{
Prediction of traits from environment, environment from traits and response 
from trait and environment data.

With \code{type = "traits"} and \code{newdata = NULL}, predict gives the 
fitted mean traits, \emph{i.e.} the fitted community weighted means.
With \code{type = "env"} and \code{newdata = NULL}, predict gives the 
fitted mean environment, \emph{i.e.} the fitted species niche centroids.
}
\details{
Variables that are in the model but not in \code{newdata} are set to their 
weighted means in the training data. Predictions are thus at the (weighted)
mean of the quantitative variables not included. Predictions with 
not-included factors are at the weighted mean (none of the factor effects 
are included).

For \code{type = "response"} and non-null newdata, the species weights of 
the training are used; the site weights are taken equal. Many of the 
predicted values may be negative, indicating expected absences (0) or small
expected response values.

Regression coefficients obtained with \code{type = "reg_env"} or  
\code{type = "reg_traits"} are for standardized traits and environmental
variables.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Condition(Manure),
             formulaTraits = ~ SLA + Height + LDMC + Condition(Seedmass) + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits)

# regression coefficients
predict(mod, type = "reg_env")
predict(mod, type = "reg_traits")

# fit the mean traits at each site (20x6),
# that is CWM at each site
pred.traits <- predict(mod, type = "traits")
head(pred.traits)

# fit the mean environment for each species (28x8)
# that is SNC of each species
pred.env <- predict(mod, type = "env")
head(pred.env)

pred.resp <- predict(mod, type = "response")
# pred has negative values and dc_CA cannot have negatives in the response
# so, modify pred.resp,
#whichgives about similar eigenvalues as the original data
pred.resp[pred.resp < 0] <- 0
mod3 <- dc_CA(formulaEnv = mod$formulaEnv,
              formulaTraits = mod$formulaTraits,
              response = pred.resp, 
              dataEnv = dune_trait_env$envir,
              dataTraits = dune_trait_env$traits)
mod3$eigenvalues / mod$eigenvalues

}
