% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{resolvePolytomies}
\alias{resolvePolytomies}
\title{Resolve polytomies to have the minimum number of single timepoint clades}
\usage{
resolvePolytomies(
  phy,
  clone,
  minlength = 0.001,
  time = "time",
  sequence = "sequence_id",
  germline = "Germline",
  verbose = FALSE
)
}
\arguments{
\item{phy}{Tree object}

\item{clone}{airrClone data object corresponding to \code{phy}}

\item{minlength}{Branch lengths to collapse in trees}

\item{time}{Column name holding numeric time information}

\item{sequence}{Column name holding sequence ID}

\item{germline}{Germline sequence name}

\item{verbose}{Print lots of rubbish while running?}
}
\value{
A \code{phylo} tree object in which polytomies are resolved to 
have the minimum number of single timepoint clades.
}
\description{
Resolve polytomies to have the minimum number of single timepoint clades
}
\details{
Iteratively identifies polytomies (clusters of < minlength branches),
prunes each descendant branch, combines clades with the same timepoint
before grouping them back together. Checks to make sure that the divergence
of each tip is the same after resolution.
}
\seealso{
Uses output from \link{getTrees} during \link{correlationTest}.
}
