% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{ddpcr-class}
\alias{ddpcr}
\alias{ddpcr-class}
\title{Class \code{"ddpcr"}}
\description{
A class specifically designed to contain results from droplet digital PCR
experiments. Data is represented as matrix, where each column describes
different experiment. Type of data in all columns is specified in
slot \code{"type"}. Inherits from \code{\linkS4class{dpcr}}.
}
\details{
For more in-depth explanation of digital PCR data structure, see 
\code{\linkS4class{dpcr}}.
}
\section{Slots}{

\describe{
\item{\code{threshold}}{\code{numeric} value giving the threshold. Partition with the value equal or 
bigger than threshold are considered positive.}
}}
\examples{

ddpcr_fluo <- sim_ddpcr(m = 10, n = 20, times = 5, fluo = list(0.1, 0))
plot(ddpcr_fluo)

ddpcr <- sim_ddpcr(m = 10, n = 20, times = 5)
}
\author{
Michal Burdukiewicz.
}
\seealso{
Ploting and managment: \code{\link{bind_dpcr}},
\code{\link{extract_dpcr}}, \code{\link{plot_vic_fam}}.

Simulation: \code{\link{sim_ddpcr}}.

Array digital PCR: \code{\linkS4class{adpcr}}.
}
\keyword{classes}

