% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dpcr.R
\name{read_dpcr}
\alias{read_dpcr}
\title{Read digital PCR data}
\usage{
read_dpcr(input, format, ext = NULL, ...)
}
\arguments{
\item{input}{name of the input file (\code{character}) or input object 
(\code{data.frame}).}

\item{format}{of the file, for example: \code{"raw"}, \code{"QX100"}, 
\code{"BioMark"}, \code{"amp"} (raw amplitude compressed using \code{.zip}).}

\item{ext}{extension of the file ().}

\item{...}{additional parameters for the appropriate function. For example, if 
\code{format} has value \code{"raw"}, the additional parameter must be 
\code{adpcr}.}
}
\value{
Always an object of \code{\linkS4class{adpcr}} or 
\code{\linkS4class{dpcr}} type.
}
\description{
Reads digital PCR data in various formats.
}
\details{
Input files may have .csv, .xls or .xlsx extension. In case of Excel files 
with multiple sheets, only the first sheet will be analyzed.
}
\author{
Michal Burdukiewcz, Stefan Roediger
}
\seealso{
Read raw format files: \code{\link{read_redf}}.
Read BioMark format files: \code{\link{read_BioMark}}.
Read QX100 format files: \code{\link{read_QX100}}.
Read QX200 format files: \code{\link{read_QX200}}.
}
\keyword{utilities}

