\name{write.tucson}
\alias{write.tucson}
\title{ Write Tucson Format Chronology File }
\description{
  This function writes a chronology to a Tucson (decadal) format file.
}
\usage{
  write.tucson(rwl.df, fname, header=NULL, append=FALSE, prec=0.01,
  mapping.fname="", mapping.append=FALSE, long.names=FALSE)
}
\arguments{
  \item{rwl.df}{ a \code{data.frame} containing tree-ring ring widths with the
  series in columns and the years as rows. The series ids are the column names
  and the years are the row names. This type of \code{data.frame} is
  produced by \code{\link{read.rwl}} and \code{\link{read.compact}}. }
  \item{fname}{ a character vector giving the file name of the rwl file. }
  \item{header}{ a list giving information for the header of the file.
  If NULL then no header information will be written. }
  \item{append}{ logical flag indicating whether to append this chronology to
  an existing file. The default is to create a new file. }
  \item{prec}{ \code{numeric} indicating the precision of the output file. -
  This must be equal to either 0.01 or 0.001 (units are in mm). }
  \item{mapping.fname}{ a \code{character} vector of length one giving
  the file name of an optional output file showing the mapping between
  input and output series ids. The mapping is only printed for those ids
  that are transformed. An empty name (the default) disables output. }
  \item{mapping.append}{ \code{logical} flag indicating whether to
  append the description of the altered series ids to an existing file.
  The default is to create a new file. }
  \item{long.names}{ \code{logical} flag indicating whether to
  allow long series IDs (7 or 8 characters) to be written to the output.
  The default is to only allow 6 characters. }
}
\details{
  This writes a standard rwl file as defined according to the standards of
  the ITRDB at \url{http://www.ncdc.noaa.gov/paleo/treeinfo.html}. This is the
  decadal or Tucson format. It is an ASCII file and machine readable by the
  standard dendrochronology programs. Header information for the rwl can
  be written according to the International Tree Ring Data Bank (ITRDB)
  standard. The header standard is not very reliable however and should
  be though of as experimental here. Do not try to write headers using
  dplR to submit to the ITRDB. When submitting to the ITRDB, you can
  enter the metadata via their website. If you insist however, the
  header information is given as a \code{list} and must be
  formatted with the following:
  \tabular{lrrr}{
    \emph{Description} \tab \emph{Name} \tab \emph{Class} \tab \emph{Max Width} \cr
    Site ID \tab site.id \tab character \tab 5 \cr
    Site Name \tab site.name \tab character \tab 52 \cr
    Species Code \tab spp.code \tab character \tab 4 \cr
    State or Country \tab state.country \tab character \tab 13 \cr
    Species \tab spp \tab character \tab 18 \cr
    Elevation \tab elev \tab character \tab 5 \cr
    Latitude \tab lat \tab character or numeric \tab 5 \cr
    Longitude \tab long \tab character or numeric \tab 5 \cr
    First Year \tab first.yr \tab character or numeric \tab 4 \cr
    Last Year \tab last.yr \tab character or numeric \tab 4 \cr
    Lead Investigator \tab lead.invs \tab character \tab 63 \cr
    Completion Date \tab comp.date \tab character \tab 8 \cr
  }
  See examples for a correctly formatted header list. If the width of
  the fields is less than the max width, then the fields will be padded
  to the right length when written. Note that lat and long are really
  lat*100 or long*100 and given as integers. E.g., 37 degrees 30 minutes
  would be given as 3750.

  Series can be appended to the bottom of an existing file with a second
  call to \code{write.tucson}. The output from this file is suitable for
  publication on the ITRDB.

  The function is capable of altering excessively long and/or duplicate
  series ids to fit the Tucson specification. Additionally, characters
  other than numbers or English letters will be removed. If series ids
  are changed, one or more warnings are shown. In that case, the user
  may wish to print a list of the renamings (see Arguments).

  Setting \code{long.names=TRUE} allows series IDs to be 8 characters
  long, or 7 in case there are year numbers using 5 characters. Note
  that in the latter case the limit of 7 characters applies to all
  IDs, not just the one corresponding to the series with long year
  numbers. The default (\code{long.names=FALSE}) is to allow 6
  characters. Long IDs may cause incompatibility with other software.
}
\value{
  None. Invoked for side effect (file is written).
 }
\author{ Andy Bunn. Patched and improved by Mikko Korpela. }
\seealso{ \code{\link{write.crn}}, \code{\link{read.tucson}},
  \code{\link{write.rwl}}, \code{\link{write.compact}},
  \code{\link{write.tridas}}
}
\examples{
 data(co021)
 co021.hdr <- list(site.id = "CO021",
    site.name = "SCHULMAN OLD TREE NO. 1, MESA VERDE",
    spp.code = "PSME", state.country = "COLORADO", spp = "DOUGLAS FIR",
    elev = "2103M", lat = 3712, long = -10830, first.yr = 1400,
    last.yr = 1963, lead.invs = "E. SCHULMAN", comp.date = "")
 write.tucson(rwl.df = co021, fname = 'tmp.rwl', header = co021.hdr,
    append = FALSE, prec = 0.001)

}
\keyword{ IO }
