% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sample.R
\name{sample}
\alias{sample}
\alias{sample_frac}
\alias{sample_n}
\title{Sample n rows from a table.}
\usage{
sample_n(tbl, size, replace = FALSE, weight = NULL, .env = parent.frame())

sample_frac(tbl, size = 1, replace = FALSE, weight = NULL,
  .env = parent.frame())
}
\arguments{
\item{tbl}{tbl of data.}

\item{size}{For \code{sample_n}, the number of rows to select.
For \code{sample_frac}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{Sampling weights. This expression is evaluated in the
context of the data frame. It must return a vector of non-negative
numbers the same length as the input. Weights are automatically
standardised to sum to 1.}

\item{.env}{Environment in which to look for non-data names used in
\code{weight}. Non-default settings for experts only.}
}
\description{
This is a wrapper around \code{\link{sample.int}} to make it easy to
select random rows from a table. It currently only works for local
tbls.
}
\examples{
by_cyl <- mtcars \%>\% group_by(cyl)

# Sample fixed number per group
sample_n(mtcars, 10)
sample_n(mtcars, 50, replace = TRUE)
sample_n(mtcars, 10, weight = mpg)

sample_n(by_cyl, 3)
sample_n(by_cyl, 10, replace = TRUE)
sample_n(by_cyl, 3, weight = mpg / mean(mpg))

# Sample fixed fraction per group
# Default is to sample all data = randomly resample rows
sample_frac(mtcars)

sample_frac(mtcars, 0.1)
sample_frac(mtcars, 1.5, replace = TRUE)
sample_frac(mtcars, 0.1, weight = 1 / mpg)

sample_frac(by_cyl, 0.2)
sample_frac(by_cyl, 1, replace = TRUE)
}

