% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{funs}
\alias{funs}
\title{Create a list of functions calls.}
\usage{
funs(..., .args = list())
}
\arguments{
\item{...}{A list of functions specified by:
\itemize{
\item Their name, \code{"mean"}
\item The function itself, \code{mean}
\item A call to the function with \code{.} as a dummy argument,
\code{mean(., na.rm = TRUE)}
}

These arguments are automatically \link[rlang:quo]{quoted}. They
support \link[rlang:quasiquotation]{unquoting} and splicing. See
\code{vignette("programming")} for an introduction to these concepts.}

\item{.args, args}{A named list of additional arguments to be added
to all function calls.}
}
\description{
\code{funs()} provides a flexible way to generate a named list of
functions for input to other functions like \code{\link[=summarise_at]{summarise_at()}}.
}
\examples{
funs(mean, "mean", mean(., na.rm = TRUE))

# Override default names
funs(m1 = mean, m2 = "mean", m3 = mean(., na.rm = TRUE))

# If you have function names in a vector, use funs_
fs <- c("min", "max")
funs_(fs)
}
