% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_group.R
\name{create_dq_box_group}
\alias{create_dq_box_group}
\title{Create a dq box group}
\usage{
create_dq_box_group(session, ...)
}
\arguments{
\item{session}{shiny session object}

\item{...}{box ids to be combined to one group}
}
\description{
Create a dq box group which automatically collapses all other
boxes whenever one box is opened.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(6,
        dq_box("Random Input1", dq_space(), "End of Content", id = "box1",
          title = "Box1", width = 12, open_callback = TRUE),
        dq_box("Random Input2", dq_space(), "End of Content", id = "box2",
          title = "Box2", width = 9, collapsed = TRUE, open_callback = TRUE),
        dq_box("Random Input3", dq_space(), "End of Content", id = "box3",
          title = "Box3", width = 12, collapsed = TRUE, open_callback = TRUE)
      )
    )
  ),
  server = function(input, output, session) {
    create_dq_box_group(session, "box1", "box2", "box3")
  }
)

}
}
\author{
richard.kunze
}
