% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_gallery.R
\name{dq_gallery}
\alias{dq_gallery}
\alias{update_dq_gallery}
\title{Creates a content gallery element}
\usage{
dq_gallery(
  id = NULL,
  ...,
  style = NULL,
  content_style = NULL,
  arrows = NULL,
  scrollable = FALSE
)

update_dq_gallery(id, set = NULL, add = NULL)
}
\arguments{
\item{id}{optional element id, useful if current state is needed}

\item{...}{content elements to show, names can be used to show titles}

\item{style, content_style}{optional character specifying additional styles}

\item{arrows}{optional list of arrows to use, by default defined as list(
dq_icon("chevron-left"), dq_icon("chevron-right")), can be a list of other
icons or freely designed html elements}

\item{scrollable}{optional logical to specify if the gallery can be moved
with a scrollbar (this option will hide arrows)}

\item{set}{index of the content element to show}

\item{add}{numeric amount of indexes to move (can also be negative)}
}
\value{
gallery element tag
}
\description{
Creates a gallery element with buttons to switch between
several content elements.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(6, dq_gallery(id = "myGallery",
        Plot1 = plotOutput("plot1"), Plot2 = plotOutput("plot2"),
        plotOutput("plot3"), plotOutput("plot4"),
        content_style = "padding: 10px 30px;", arrows = list(
          dq_icon("chevron-circle-left"), dq_icon("chevron-circle-right")
        )
      )),
      column(6,
        actionButton("show3", "Show plot 3"),
        actionButton("anim", "Animate Plots")
      )
    )
  ),
  server = function(input, output) {
    output$plot1 <- renderPlot(plot(mtcars$mpg, mtcars$cyl))
    output$plot2 <- renderPlot(plot(mtcars$disp, mtcars$hp))
    output$plot3 <- renderPlot(plot(mtcars$drat, mtcars$wt))
    output$plot4 <- renderPlot(plot(mtcars$qsec, mtcars$vs))

    observeEvent(input$show3, update_dq_gallery("myGallery", set = 3))
    observeEvent(input$anim, {
      for(i in 1:30) {update_dq_gallery("myGallery", add = .1);Sys.sleep(.2)}
    })
  }
)

}
}
\author{
richard.kunze
}
