% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_box.R
\name{dq_box}
\alias{dq_box}
\alias{update_dq_box}
\title{Creates a html box with specified parameters}
\usage{
dq_box(
  ...,
  id = NULL,
  title = NULL,
  color = "#000",
  bg_color = "#ff8f00",
  fill = TRUE,
  width = 6L,
  height = NULL,
  offset = 0L,
  collapsible = FALSE,
  collapsed = FALSE,
  open_callback = FALSE
)

update_dq_box(id, collapsed = NULL, silent = FALSE)
}
\arguments{
\item{...}{Tags to add to the box as children.}

\item{id}{ID of the box, can be used to observe collapse events via
input[[paste0(id, "_collapser")]].}

\item{title}{Title of the box, always visible.}

\item{color}{Optional, sets the font color of the box, can be any valid
html color, defaults to black.}

\item{bg_color}{Optional, sets the background color of the box, can be any
valid html color, defaults to dq primary orange.}

\item{fill}{Optional logical, decide whether to fill the body with
background color or not, if not, a border of this color will be set
instead.}

\item{width}{Optional, width of the box measured in bootstrap columns.}

\item{height}{Optional, height of the box, can be numeric, which will result
in pixels, or measured in any valid CSS3 length format, if the given body
is larger than this value overflow will be set to auto, resulting in a
scrollable body.}

\item{offset}{Optional, offset of the resulting column measured in bootstrap
columns.}

\item{collapsible}{Optional logical, whether the box is collapsible or not.}

\item{collapsed}{Optional logical, whether the box is initially collapsed or
not.}

\item{open_callback}{optional logical, whether to send messages whenever the
state of the box changes or not, events will be available via
input[[paste0(id, "_open")]]}

\item{silent}{optional logical indicating to suppress events or not}
}
\value{
bootstrap column holding the box
}
\description{
Creates a fully customizable HTML box holding the given content.
Can be made collapsible and nested.

Function to update the collapsed state of a dq_box.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      dq_box(
        title = "Say Hello to my children", id = "bigBox", collapsed = TRUE,
        dq_infobox("hallo", 2, "Welt", icon("hashtag"),
                   bg_color = "black", color = "#D00"),
        dq_box(
          title = "Box in the box", bg_color = "pink", width = 8,
          dq_infobox("in the box...", 2, "in the box!", width = 12,
                     bg_color = "white", color = "#0D0")
          )
        ),
      column(3, actionButton("toggle", "Toggle Box"))
     )
  ),
  server = function(input, output) {
    observeEvent(input$toggle, update_dq_box("bigBox"))
  }
)

}
}
\author{
richard.kunze
}
