% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{FindHillBounds}
\alias{FindHillBounds}
\title{Compute the Hill bounds based on initial parameter estimates and data.}
\usage{
FindHillBounds(x, y, theta, use.Hessian = FALSE, level = 0.9999)
}
\arguments{
\item{x}{Vector of doses.}

\item{y}{Vector of responses.}

\item{theta}{Parameters of a 4PL model.}

\item{use.Hessian}{Indicator of whether the Hessian matrix (TRUE) or the
gradient vector is used in confidence interval computation.}

\item{level}{Confidence level to be used in computing the Hill bounds.}
}
\value{
Data frame whose first column represents the bounds on the IC50 parameter
in log 10 scale and second column represents the bounds on the slope parameter.
}
\description{
Compute the Hill bounds based on initial parameter estimates and data.
}
\details{
This function computes the Hill bounds based on initial parameter
estimates and data. It basically computes the confidence intervals of the
true parameters based on the variance-covariance matrix of a given initial
parameter estimates. The half of a hessian matrix is used as a
variance-covariance matrix. If matrix inversion of the variance-covariance matrix
is infeasible, a variation of the method in Wang et al. (2010) is used. The
parameter \code{level} is only for simulation.
}
\references{
\insertRef{Higham2002}{dr4pl} \insertRef{Wang2010}{dr4pl}
}
\seealso{
\code{\link{FindInitialParms}}, \code{\link{FindLogisticGrids}}.
}
\author{
Hyowon An, \email{ahwbest@gmail.com}.
}
