% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_runtime.R
\name{rate_limiting_times}
\alias{rate_limiting_times}
\title{Function rate_limiting_times}
\usage{
rate_limiting_times(plan, from_scratch = FALSE, targets_only = FALSE,
  targets = drake::possible_targets(plan), envir = parent.frame(),
  verbose = TRUE, cache = NULL,
  parallelism = drake::default_parallelism(), jobs = 1,
  future_jobs = jobs, packages = (.packages()), prework = character(0),
  config = NULL, digits = 0, path = getwd(), search = TRUE)
}
\arguments{
\item{plan}{same as for \code{\link{make}}}

\item{from_scratch}{logical, whether to assume
next hypothetical call to \code{\link{make}()}
is a build from scratch (after \code{\link{clean}()}).}

\item{targets_only}{logical, whether to factor in just the
targets or use times from everything, including the imports.}

\item{targets}{Targets to build in the workflow.
Timing information is
limited to these targets and their dependencies.}

\item{envir}{same as for \code{\link{make}}. Supercedes
\code{config$envir}.}

\item{verbose}{same as for \code{\link{make}}}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
The \code{cache} argument is ignored if a
non-null \code{config} argument is supplied.}

\item{parallelism}{same as for \code{\link{make}}, and
also used to process imported objects/files.}

\item{jobs}{same as for \code{\link{make}}, just used to
process imports.}

\item{future_jobs}{hypothetical number of jobs
assumed for the predicted runtime.
assuming this number of jobs.}

\item{packages}{same as for \code{\link{make}}}

\item{prework}{same as for \code{\link{make}}}

\item{config}{option internal runtime parameter list of
\code{\link{make}(...)},
produced with \code{\link{config}()}.
\code{config$envir} is ignored.
Otherwise, computing this
in advance could save time if you plan multiple calls to
this function.}

\item{digits}{number of digits for rounding the times.}

\item{path}{file path to the folder contianing the cache.
Yes, this is the parent directory containing the cache,
not the cache itself.}

\item{search}{logical, whether to search back in the file system
for the cache.}
}
\description{
Return a data frame of elapsed build times of
the rate-limiting targets of a \code{\link{make}()} workflow.
}
\details{
The \code{stage} column of the returned data frame
is an index that denotes a parallelizable stage.
Within each stage during \code{\link{make}()},
the targets are divided among the available jobs.
For \code{rate_limiting_times()},
we assume the targets are divided evenly among the jobs
and one job gets all the slowest targets.
The build times of this hypothetical pessimistic job
are returned for each stage. \cr

By default \code{from_scratch} is \code{FALSE}. That way,
\code{rate_limiting_times()} takes into account that some
targets are already up to date, meaning their elapsed
build times will be instant during the next \code{\link{make}()}.

For the results to make sense, the previous build times
of all targets need to be available (automatically cached
by \code{\link{make}()}). Otherwise, \code{rate_limiting_times()}
will warn you and tell you which targets have missing times.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
rate_limiting_times(my_plan) # everything is up to date
rate_limiting_times(my_plan, from_scratch  = TRUE, digits = 4) # 1 job
rate_limiting_times(
  my_plan,
  future_jobs = 2,
  from_scratch = TRUE,
  digits = 4
)
rate_limiting_times(
  my_plan,
  targets = c("small", "large"),
  future_jobs = 2,
  from_scratch = TRUE,
  digits = 4
)
}
}
\seealso{
\code{\link{predict_runtime}},
\code{\link{build_times}}
\code{\link{make}}
}
