% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_graph}
\alias{read_graph}
\title{Function \code{read_graph}}
\usage{
read_graph(path = getwd(), search = TRUE, cache = NULL, ...)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{...}{arguments to \code{visNetwork()} via \code{\link{plot_graph}()}}
}
\value{
either a plot or an igraph object, depending
on \code{plot}
}
\description{
Read the igraph-style dependency graph of your targets
from your last attempted call to \code{\link{make}()}.
For better graphing utilities, see \code{\link{plot_graph}()}
and related functions.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
g <- read_graph(plot = FALSE)
class(g)
read_graph() # Actually plot the graph as an interactive visNetwork widget.
}
}
\seealso{
\code{\link{plot_graph}}, \code{\link{read_config}}
}
