% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{deps}
\alias{deps}
\title{Function deps}
\usage{
deps(x)
}
\arguments{
\item{x}{Either a function or a string.
Strings are commands from your workflow plan data frame.}
}
\value{
names of dependencies. Files wrapped in single quotes.
The other names listed are functions or generic objects.
}
\description{
List the dependencies of a function or workflow plan command.
Or, if the argument is a single-quoted string that points to
a dynamic knitr report, the dependencies of the expected compiled
output will be given. For example, \code{deps("'report.Rmd'")}
will return target names found in calls to \code{\link{loadd}()}
and \code{\link{readd}()} in active code chunks.
These targets are needed in order to run \code{knit('report.Rmd')}
to produce the output file \code{'report.md'}, so technically,
they are dependencies of \code{'report.md'}, not \code{'report.Rmd'}
}
\examples{
f <- function(x, y){
  out <- x + y + g(x)
  saveRDS(out, 'out.rds')
}
deps(f)
my_plan <- workplan(
  x = 1 + some_object,
  my_target = x + readRDS('tracked_input_file.rds'),
  return_value = f(x, y, g(z + w))
)
deps(my_plan$command[1])
deps(my_plan$command[2])
deps(my_plan$command[3])
\dontrun{
load_basic_example() # Writes 'report.Rmd'.
deps("'report.Rmd'") # dependencies of future knitted output 'report.md'
}
}
