% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_history.R
\name{drake_history}
\alias{drake_history}
\title{History and provenance
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
drake_history(cache = NULL, history = NULL, analyze = TRUE, verbose = NULL)
}
\arguments{
\item{cache}{drake cache as created by \code{\link[=new_cache]{new_cache()}}.
See also \code{\link[=drake_cache]{drake_cache()}}.}

\item{history}{Logical, whether to record the build history
of your targets. You can also supply a
\href{https://github.com/wlandau/txtq}{\code{txtq}}, which is
how \code{drake} records history.
Must be \code{TRUE} for \code{\link[=drake_history]{drake_history()}} to work later.}

\item{analyze}{Logical, whether to analyze \code{\link[=drake_plan]{drake_plan()}}
commands for arguments to function calls.
Could be slow because this requires parsing and analyzing
lots of R code.}

\item{verbose}{Deprecated on 2019-09-11.}
}
\value{
A data frame of target history.
}
\description{
See the history and provenance of your targets:
what you ran, when you ran it, the function arguments
you used, and how to get old data back.
}
\details{
\code{\link[=drake_history]{drake_history()}} returns a data frame with the following columns.
\itemize{
\item \code{target}: the name of the target.
\item \code{current}: logical, whether the row describes the data
actually assigned to the target name in the cache,
e.g. what you get with \code{loadd(target)} and \code{readd(target)}.
Does \strong{NOT} tell you if the target is up to date.
\item \code{built}: when the target's value was stored in the cache.
This is the true creation date of the target's value,
not the recovery date from \code{make(recover = TRUE)}.
\item \code{exists}: logical, whether the target's historical value
still exists in the cache. Garbage collection via
(\code{clean(garbage_collection = TRUE)} and \code{drake_cache()$gc()})
remove these historical values, but \code{clean()} under the default
settings does not.
\item \code{hash}: fingerprint of the target's historical value in the cache.
If the value still exists, you can read it with
\code{drake_cache()$get_value(hash)}.
\item \code{command}: the \code{\link[=drake_plan]{drake_plan()}} command executed to build the target.
\item \code{seed}: random number generator seed.
\item \code{runtime}: the time it took to execute the \code{\link[=drake_plan]{drake_plan()}} command.
Does not include overhead due to \code{drake}'s processing.
}

If \code{analyze} is \code{TRUE}, various other columns are included to show
the explicitly-named length-1 arguments to function calls in the commands.
See the "Provenance" section for more details.
}
\section{Provenance}{

If \code{analyze} is \code{TRUE}, \code{drake}
scans your \code{\link[=drake_plan]{drake_plan()}} commands
for function arguments and mentions them in the history.
A function argument shows up if and only if:
1. It has length 1. \cr
2. It is atomic, i.e. a base type: logical, integer,
real, complex, character, or raw. \cr
3. It is explicitly named in the function call,
For example, \code{x} is detected as \code{1} in
\code{fn(list(x = 1))} but not \code{f(list(1))}.
The exceptions are \code{\link[=file_out]{file_out()}}, \code{\link[=file_in]{file_in()}},
and \code{\link[=knitr_in]{knitr_in()}}. For example, \code{filename} is detected
as \code{"my_file.csv"} in
\code{process_data(filename = file_in("my_file.csv"))}.
NB: in \code{process_data(filename = file_in("a", "b"))}
\code{filename} is not detected because the value must be atomic. \cr
}

\examples{
\dontrun{
isolate_example("contain side-effects", {
if (requireNamespace("knitr", quietly = TRUE)) {
# First, let's iterate on a drake workflow.
load_mtcars_example()
make(my_plan, history = TRUE, verbose = 0L)
# Naturally, we'll make updates to our targets along the way.
reg2 <- function(d) {
  d$x2 <- d$x ^ 3
  lm(y ~ x2, data = d)
}
Sys.sleep(0.01)
make(my_plan, history = TRUE, verbose = 0L)
# The history is a data frame about all the recorded runs of your targets.
out <- drake_history(analyze = TRUE)
print(out)
# Let's use the history to recover the oldest version
# of our regression2_small target.
oldest_reg2_small <- max(which(out$target == "regression2_small"))
hash_oldest_reg2_small <- out[oldest_reg2_small, ]$hash
cache <- drake_cache()
cache$get_value(hash_oldest_reg2_small)
# If you run clean(), drake can still find all the targets.
clean(small)
drake_history()
# But if you run clean() with garbage collection,
# older versions of your targets may be gone.
clean(large, garbage_collection = TRUE)
drake_history()
invisible()
}
})
}
}
