% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-times.R
\name{build_times}
\alias{build_times}
\title{List the time it took to build each target.}
\usage{
build_times(..., path = NULL, search = NULL, digits = 3,
  cache = drake_cache(path = path, verbose = verbose),
  targets_only = NULL, verbose = 1L, jobs = 1, type = c("build",
  "command"), list = character(0))
}
\arguments{
\item{...}{Targets to load from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{digits}{How many digits to round the times to.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{targets_only}{Deprecated.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{type}{Type of time you want: either \code{"build"}
for the full build time including the time it took to
store the target, or \code{"command"} for the time it took
just to run the command.}

\item{list}{Character vector of targets to select.}
}
\value{
A data frame of times, each from \code{\link[=system.time]{system.time()}}.
}
\description{
Applies to targets in your plan, not imports or files.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
if (requireNamespace("lubridate")) {
# Show the build times for the mtcars example.
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Build all the targets.
print(build_times()) # Show how long it took to build each target.
}
}
})
}
}
\seealso{
\code{\link[=predict_runtime]{predict_runtime()}}
}
