% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{prioritize_driver_genes}
\alias{prioritize_driver_genes}
\title{Prioritize Cancer Driver Genes}
\usage{
prioritize_driver_genes(features_df, cancer_type)
}
\arguments{
\item{features_df}{the features data frame for all genes, containing the following columns:
\describe{
\item{gene_symbol}{HGNC gene symbol}
\item{metaprediction_score}{the maximum metapredictor (coding) impact score for the gene}
\item{noncoding_score}{the maximum non-coding PHRED-scaled CADD score for the gene}
\item{scna_score}{SCNA proxy score. SCNA density (SCNA/Mb) of the minimal common region (MCR) in which the gene is located}
\item{hotspot_double_hit}{boolean indicating whether the gene is a hotspot gene (indication of oncogenes) or subject to double-hit (indication of tumor-suppressor genes)}
\item{phenolyzer_score}{'phenolyzer' score for the gene}
\item{hsa03320}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04010}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04020}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04024}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04060}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04066}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04110}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04115}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04150}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04151}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04210}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04310}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04330}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04340}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04350}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04370}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04510}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04512}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04520}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04630}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04915}{boolean indicating whether or not the gene takes part in this KEGG pathway}
}}

\item{cancer_type}{short name of the cancer type. All available cancer types
are listed in \code{\link{MTL_submodel_descriptions}}}
}
\value{
data frame with 3 columns:
\describe{
\item{gene_symbol}{HGNC gene symbol}
\item{driverness_prob}{estimated probability for each gene in \code{features_df} of being a
cancer driver. The probabilities are calculated using the selected (via
\code{cancer_type}) cancer type's sub-model.}
\item{prediction}{prediction based on the cancer-type-specific threshold (either "driver" or "non-driver")}
}
}
\description{
Prioritize Cancer Driver Genes
}
\examples{
drivers_df <- prioritize_driver_genes(example_features_table, "LUAD")

}
\seealso{
\code{\link{create_features_df}} for creating the features table.
\code{\link{TCGA_MTL_fit}} for details on the MTL model used for prediction.
}
