% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_normal.R
\name{EPsProg23_normal}
\alias{EPsProg23_normal}
\title{Expected probability of a successful program deciding between two or three phase III trials for a normally distributed outcome}
\usage{
EPsProg23_normal(
  kappa,
  n2,
  alpha,
  beta,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  case,
  size,
  ymin
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be an even number}

\item{alpha}{significance level}

\item{beta}{type II error rate; this means that 1 - \code{beta} is the power for calculating the sample size for phase III}

\item{w}{weight for the mixture prior distribution}

\item{Delta1}{assumed true treatment effect for the standardized difference in means}

\item{Delta2}{assumed true treatment effect for the standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{case}{number of significant trials needed for approval; possible values are 2 and 3 for this function}

\item{size}{effect size category; possible values are \code{"small"}, \code{"medium"}, \code{"large"} and \code{"all"}}

\item{ymin}{assumed minimal clinical relevant effect}
}
\value{
The output of the function \code{EPsProg23_normal()} is the expected probability of a successful program.
}
\description{
The function \code{EPsProg23_normal()} calculates the expected probability of a successful program
with a normally distributed outcome. This function follows a special decision rule in order to determine
whether two or three phase III trials should be conducted. First, two phase III trials are performed. Depending
on their success, the decision for a third phase III trial is made:
\itemize{
\item If both trials are successful, no third phase III trial will be conducted.
\item If only one of the two trials is successful and the other trial has a treatment effect that points in the same direction,
a third phase III trial will be conducted with a sample size of N3 = N3(ymin), which depends on an assumed minimal clinical relevant effect (\code{ymin}).
The third trial then has to be significant at level \code{alpha}
\item If only one of the two trials is successful and the treatment effect of the other points in opposite direction or
if none of the two trials are successful, then no third trial is performed and the drug development development program is not successful.
In the utility function, this will lead to a utility of -9999.
}
}
\examples{
\donttest{EPsProg23_normal(kappa = 0.1, n2 = 50, alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 case = 2, size = "small", ymin = 0.5)}
}
\keyword{internal}
