% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_normal.R
\name{utility_multitrial_normal}
\alias{utility_multitrial_normal}
\alias{utility2_normal}
\alias{utility3_normal}
\alias{utility4_normal}
\title{Utility function for multitrial programs with normally distributed outcomes}
\usage{
utility2_normal(
  n2,
  kappa,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility3_normal(
  n2,
  kappa,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility4_normal(
  n2,
  kappa,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{kappa}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{case}{choose case: "at least 1, 2 or 3 significant trials needed for approval"}

\item{fixed}{choose if true treatment effects are fixed or random}
}
\value{
The output of the functions utility2_normal(), utility3_normal() and utility4_normal() is the expected utility of the program when 2, 3 or 4 phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_multitrial_normal()} function.
}
\examples{
res <- utility2_normal(kappa = 0.1, n2 = 50,  alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,
                                 K = Inf, N = Inf, S = -Inf, 
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 case = 2, fixed = TRUE)
          res <- utility3_normal(kappa = 0.1, n2 = 50,  alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 case = 2, fixed = TRUE)                        
          res <- utility4_normal(kappa = 0.1, n2 = 50,  alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,
                                 K = Inf, N = Inf, S = -Inf, 
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 case = 3, fixed = TRUE)
}
\keyword{internal}
