% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{what_date}
\alias{what_date}
\title{What date is it?}
\usage{
what_date(when = NA, rev = FALSE, sep = "-", month_form = "m")
}
\arguments{
\item{when}{Date (as a scalar or vector).
Default: \code{when = NA}. 
Using \code{as.Date(when)} to convert strings into dates, 
and \code{Sys.Date()}, if \code{when = NA}.}

\item{rev}{Boolean: Reverse date (to %d-%m-%Y)?
Default: \code{rev = FALSE}.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = "-"}.}

\item{month_form}{Character: Month format. 
Default: \code{month_form = "m"} for numeric month (01-12). 
Use \code{month_form = "b"} for short month name 
and \code{month_form = "B"} for full month name (in current locale).}
}
\description{
\code{what_date} provides a satisficing version of 
\code{Sys.Date()} that is sufficient for most purposes.
}
\details{
\code{what_date} returns either a simple version of 
\code{when} or \code{Sys.Date()}  
(in %Y-%m-%d format) 
using current system settings.
}
\examples{
what_date()  
what_date(sep = "/")
what_date(rev = TRUE)
what_date(rev = TRUE, sep = ".")
what_date(rev = TRUE, sep = " ", month_form = "B")

# with vector (of dates):
ds <- c("2020-01-15 01:02:03 CET", "2020-12-31 14:15:16")
what_date(ds)
what_date(ds, rev = TRUE, sep = ".")
what_date(ds, rev = TRUE, month_form = "b")

}
\seealso{
\code{what_day()} function to obtain (week)days; 
\code{what_time()} function to obtain times; 
\code{cur_time()} function to print the current time; 
\code{cur_date()} function to print the current date; 
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
