% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{count_chars_words}
\alias{count_chars_words}
\title{Count the frequency of characters and words in a string of text \code{x}.}
\usage{
count_chars_words(x, case_sense = TRUE, sep = "|", rm_sep = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{case_sense}{Boolean: Distinguish lower- vs. uppercase characters? 
Default: \code{case_sense = TRUE}.}

\item{sep}{Dummy character(s) to insert between elements/lines 
when parsing a multi-element character vector \code{x} as input. 
This character is inserted to mark word boundaries in multi-element 
inputs \code{x} (without punctuation at the boundary).  
It should NOT occur anywhere in \code{x}, 
so that it can be removed again (by \code{rm_sep = TRUE}). 
Default: \code{sep = "|"} (i.e., insert a vertical bar between lines).}

\item{rm_sep}{Should \code{sep} be removed from output? 
Default: \code{rm_sep = TRUE}.}
}
\value{
A data frame with 4 variables 
(\code{char}, \code{char_freq}, \code{word}, \code{word_freq}).
}
\description{
\code{count_chars_words} provides frequency counts of the 
characters and words of a string of text \code{x} 
on a per character basis.
}
\details{
\code{count_chars_words} calls both \code{\link{count_chars}} and 
\code{\link{count_words}} and maps their results 
to a data frame that contains a row for each 
character of \code{x}. 

The quantifications are case-sensitive. 
Special characters (e.g., parentheses, punctuation, and spaces) 
are counted as characters, but removed from word counts. 

If input \code{x} consists of multiple text strings, 
they are collapsed with an added " " (space) between them.
}
\examples{
s1 <- ("This test is to test this function.")
head(count_chars_words(s1))
head(count_chars_words(s1, case_sense = FALSE))

s3 <- c("A 1st sentence.", "The 2nd sentence.", 
        "A 3rd --- and also THE  FINAL --- SENTENCE.")
tail(count_chars_words(s3))
tail(count_chars_words(s3, case_sense = FALSE))

}
\seealso{
\code{\link{count_chars}} for counting the frequency of characters;  
\code{\link{count_words}} for counting the frequency of words;   
\code{\link{plot_chars}} for a character plotting function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
