% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{erfcinv}
\alias{erfcinv}
\alias{erfcinv,}
\alias{d1qnormdx1,}
\alias{d2qnormdx2,}
\alias{vec_T.Owen,}
\alias{vec_qsn,}
\alias{pos_eigen,}
\alias{remove_attr}
\alias{erf}
\alias{erfc}
\alias{erfinv}
\alias{d1qnormdx1}
\alias{d2qnormdx2}
\alias{vec_T.Owen}
\alias{vec_qsn}
\alias{pos_eigen}
\title{Utility functions}
\usage{
erfcinv(x)

erf(x)

erfc(x)

erfinv(x)

d1qnormdx1(x)

d2qnormdx2(x)

vec_T.Owen(h, a, jmax = 50, cut.point = 8)

vec_qsn(
  p,
  xi = 0,
  omega = 1,
  alpha = 0,
  tau = 0,
  dp = NULL,
  tol = 1e-08,
  solver = "NR",
  ...
)

pos_eigen(H)

remove_attr(object)
}
\arguments{
\item{x}{vector of quantiles.}

\item{h}{numeric vector, for more details see \code{\link[sn:T.Owen]{T.Owen}}.}

\item{a}{numeric vector, for more details see \code{\link[sn:T.Owen]{T.Owen}}.}

\item{p}{numeric vector.}

\item{xi}{numeric vector, for more details see \code{\link[sn:qsn]{qsn}}.}

\item{omega}{numeric vector, for more details see \code{\link[sn:qsn]{qsn}}.}

\item{alpha}{numeric vector, for more details see \code{\link[sn:qsn]{qsn}}.}

\item{H}{symmetric matrix of full rank.}

\item{object}{vector or matrix.}
}
\value{
erfcinv returns a vector of the inverse complementary error function evaluated at x.

erf returns a vector of the error function evaluated at x.

erfc returns a vector of complementary error function evaluated at x.

erfinv returns a vector of the inverse error function evaluated at x.

d1qnormdx1 returns a vector of first derivative of quantile function of the standard normal distribution evaluated at x.

d2qnormdx2 returns a vector of second derivative of quantile function of the standard normal distribution evaluated at x.

vec_T.Owen returns a vector of the T.Owen function evaluated at h and a.

vec_qsn returns a vector of quantile function of the skew-normal distribution.

pos_eigen returns a list with three elements: 1) Matrix with positive eigenvalues, 2) Matrix with square root of positive eigenvalues and 3) Matrix with inverse positive eigenvalues.

remove_attr returns the input object without attributes.
}
\description{
Collection of utility functions.
}
\details{
Collection of utility functions which are for internal usage.
}
\section{Functions}{
\itemize{
\item \code{erf()}: error function

\item \code{erfc()}: complementary error function

\item \code{erfinv()}: inverse error function

\item \code{d1qnormdx1()}: First derivative of quantile function of the standard normal distribution

\item \code{d2qnormdx2()}: Second derivative of quantile function of the standard normal distribution

\item \code{vec_T.Owen()}: Vectorized T.Owen function T(h,a)

\item \code{vec_qsn()}: Vectorized quantile function of the skew normal distribution

\item \code{pos_eigen()}: Positive eigenvalue function

\item \code{remove_attr()}: Remove attribute function

}}
\examples{
erfcinv(0.5)
d1qnormdx1(0.5)
d2qnormdx2(0.5)
vec_T.Owen(c(1,1),c(1,2))
vec_qsn(c(0.5,0.5))
x<-1
attr(x,"gradient")<-2
x<-remove_attr(x)

}
\keyword{internal}
