% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsos-plot.R
\name{plot.outlier.test}
\alias{plot.outlier.test}
\title{Plot the result of the D-SOS test.}
\usage{
\method{plot}{outlier.test}(x, ...)
}
\arguments{
\item{x}{A \code{outlier.test} object from a D-SOS test.}

\item{...}{Placeholder to be comptatible with S3 `plot` generic.}
}
\value{
A \pkg{ggplot2} plot with outlier scores and p-value.
}
\description{
Plot the result of the D-SOS test.
}
\examples{
\donttest{
set.seed(12345)
data(iris)
x_train <- iris[1:50, 1:4] # Training sample: Species == 'setosa'
x_test <- iris[51:100, 1:4] # Test sample: Species == 'versicolor'
iris_test <- od_pt(x_train, x_test)
plot(iris_test)
}

}
