% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlFunctions.R
\name{gammaControl}
\alias{gammaControl}
\title{Control Function for Gamma Method Confidence Intervals}
\usage{
gammaControl(midp = FALSE, nmc = 0, wmtype = c("max", "mean", "minmaxavg",
  "tcz"), unirootTolFactor = 10^(-6))
}
\arguments{
\item{midp}{logical. Use mid-p confidence distribution method? Currently
only implemented where `wmtype = "max"``}

\item{nmc}{Calculation method when \code{midp=TRUE}.}

\item{wmtype}{type of modification for the Gamma confidence interval.}

\item{unirootTolFactor}{tolerance factor for unirott where \code{midp = TRUE}
and \code{nmc = 0}.}
}
\value{
A list of arguments to pass to \code{\link[asht]{wspoissonTest}}.
If \code{midp = TRUE}, with values
\itemize{
\item \code{midp}
\item \code{nmc}
\item \code{unirootTolFactor}
}

If \code{midp = FALSE}, with values
\itemize{
\item \code{wmtype}
}
}
\description{
Provides a list of arguments to pass to
\code{\link[asht]{wspoissonTest}}.
}
\seealso{
\code{\link[asht]{wspoissonTest}}
}
