% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_tz}
\alias{check_tz}
\title{Check Time Zone}
\usage{
check_tz(x, tz = dtt_tz(x), x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{tz}{A string of the time zone to check that x's matches.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks an object's time zone as returned by \code{dtt_tz()}.
}
\examples{
check_tz(Sys.time(), "UTC", error = FALSE)
}
\seealso{
\code{\link{dtt_tz}}
}
