% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlignments.R
\name{plotAlignments}
\alias{plotAlignments}
\title{Plotting alignments}
\usage{
plotAlignments(
  x,
  timeseries.labels = NULL,
  patterns.labels = NULL,
  attr = 1,
  threshold = Inf
)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwMatches}}.}

\item{timeseries.labels}{the label or index of the time series.
Default is 1.}

\item{patterns.labels}{a vector with labels of the patterns. If not 
declared the function will plot the alignments for all patterns in \code{x}.}

\item{attr}{An \link[base]{integer} or \link[base]{character} vector 
indicating the attribute for plotting. Default is 1.}

\item{threshold}{A number. The TWDTW dissimilarity threshold, \emph{i.e.} the 
maximum TWDTW cost for consideration. Default is \code{Inf}.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting the alignments and TWDTW 
dissimilarity measures.
}
\examples{
log_fun = logisticWeight(-0.1, 100)
ts = twdtwTimeSeries(MOD13Q1.ts.list)
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
mat1 = twdtwApply(x=ts, y=patt, weight.fun=log_fun, keep=TRUE, legacy=TRUE)

plotAlignments(mat1)

plotAlignments(mat1, attr=c("evi","ndvi"))

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{plotPaths}}, 
\code{\link[dtwSat]{plotCostMatrix}},
\code{\link[dtwSat]{plotMatches}}, and
\code{\link[dtwSat]{plotClassification}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
