% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBA.R
\name{DBA}
\alias{DBA}
\title{DTW Barycenter Averaging}
\usage{
DBA(X, centroid = NULL, ..., window.size = NULL, norm = "L1",
  max.iter = 20L, delta = 0.001, error.check = TRUE, trace = FALSE,
  gcm = NULL, mv.ver = "by-variable")
}
\arguments{
\item{X}{A matrix or data frame where each row is a time series, or a list where each element is
a time series. Multivariate series should be provided as a list of matrices where time spans
the rows and the variables span the columns of each matrix.}

\item{centroid}{Optionally, a time series to use as reference. Defaults to a random series of \code{X}
if \code{NULL}. For multivariate series, this should be a matrix with the same characteristics as
the matrices in \code{X}.}

\item{...}{Further arguments for \code{\link[=dtw_basic]{dtw_basic()}}. However, the following are already pre-
specified: \code{window.size}, \code{norm} (passed along), and \code{backtrack}.}

\item{window.size}{Window constraint for the DTW calculations. \code{NULL} means no constraint. A
slanted band is used by default.}

\item{norm}{Norm for the local cost matrix of DTW. Either "L1" for Manhattan distance or "L2" for
Euclidean distance.}

\item{max.iter}{Maximum number of iterations allowed.}

\item{delta}{At iteration \code{i}, if \code{all(abs(centroid_{i}} \code{-} \code{centroid_{i-1})} \code{< delta)},
convergence is assumed.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}

\item{trace}{If \code{TRUE}, the current iteration is printed to output.}

\item{gcm}{Optional matrix to pass to \code{\link[=dtw_basic]{dtw_basic()}} (for the case when \code{backtrack = TRUE}). To
define the matrix size, it should be assumed that \code{x} is the \emph{longest} series in \code{X}, and \code{y}
is the \code{centroid} if provided or \code{x} otherwise.}

\item{mv.ver}{Multivariate version to use. See below.}
}
\value{
The average time series.
}
\description{
A global averaging method for time series under DTW (Petitjean, Ketterlin and Gancarski 2011).
}
\details{
This function tries to find the optimum average series between a group of time series in DTW
space. Refer to the cited article for specific details on the algorithm.

If a given series reference is provided in \code{centroid}, the algorithm should always converge to
the same result provided the elements of \code{X} keep the same values, although their order may
change.

The windowing constraint uses a centered window. The calculations expect a value in
\code{window.size} that represents the distance between the point considered and one of the edges
of the window. Therefore, if, for example, \code{window.size = 10}, the warping for an
observation \eqn{x_i} considers the points between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting
in \code{10(2) + 1 = 21} observations falling within the window.
}
\note{
The indices of the DTW alignment are obtained by calling \code{\link[=dtw_basic]{dtw_basic()}} with \code{backtrack = TRUE}.
}
\section{Multivariate series}{


There are currently 2 versions of DBA implemented for multivariate series:
\itemize{
\item If \code{mv.ver = "by-variable"}, then each variable of each series in \code{X} and \code{centroid} are
extracted, and the univariate version of the algorithm is applied to each set of variables,
binding the results by column. Therefore, the DTW backtracking is different for each
variable.
\item If \code{mv.ver = "by-series"}, then all variables are considered at the same time, so the DTW
backtracking is computed based on each multivariate series as a whole. This version was
implemented in version 4.0.0 of \pkg{dtwclust}, and it might be faster.
}
}

\examples{

# Sample data
data(uciCT)

# Obtain an average for the first 5 time series
dtw_avg <- DBA(CharTraj[1:5], CharTraj[[1]], trace = TRUE)

# Plot
matplot(do.call(cbind, CharTraj[1:5]), type = "l")
points(dtw_avg)

# Change the provided order
dtw_avg2 <- DBA(CharTraj[5:1], CharTraj[[1]], trace = TRUE)

# Same result?
all(dtw_avg2 == dtw_avg2)

}
\references{
Petitjean F, Ketterlin A and Gancarski P (2011). ``A global averaging method for dynamic time
warping, with applications to clustering.'' \emph{Pattern Recognition}, \strong{44}(3), pp. 678 - 693. ISSN
0031-3203, \url{http://dx.doi.org/10.1016/j.patcog.2010.09.013},
\url{http://www.sciencedirect.com/science/article/pii/S003132031000453X}.
}
