% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLUSTERING-cvi-evaluators.R
\name{cvi_evaluators}
\alias{cvi_evaluators}
\title{Cluster comparison based on CVIs}
\usage{
cvi_evaluators(type = "valid", fuzzy = FALSE, ground.truth = NULL)
}
\arguments{
\item{type}{A character vector with options supported by \code{\link[=cvi]{cvi()}}.}

\item{fuzzy}{Logical indicating whether to use fuzzy CVIs or not.}

\item{ground.truth}{A vector that can be coerced to integers used for the calculation of external
CVIs (passed as \code{b} to \code{\link[=cvi]{cvi()}}).}
}
\value{
A list with two functions: \code{score} and \code{pick}.
}
\description{
Create evaluation functions for \code{\link[=compare_clusterings]{compare_clusterings()}}.
}
\details{
Think of this as a factory for \code{\link[=compare_clusterings]{compare_clusterings()}} that creates functions that can be passed
as its \code{score.clus} and \code{pick.clus} arguments. It is somewhat limited in scope because it depends
on the cluster validity indices available in \code{\link[=cvi]{cvi()}} for scoring and performs \emph{majority voting}
for picking. They always assume that no errors occurred.

The scoring function takes the CVIs that are to be minimized and "inverts" them by taking their
reciprocal so that maximization can be considered. Its ellipsis (\code{...}) is passed to \code{\link[=cvi]{cvi()}}.

The picking function returns the best configuration if \code{return.objects} is \code{FALSE}, or a list
with the chosen \linkS4class{TSClusters} object and the corresponding configuration otherwise.

Refer to the examples in \code{\link[=compare_clusterings]{compare_clusterings()}}.
}
\note{
To avoid ambiguity, if this function is used, configurations for both fuzzy and crisp clusterings
should \emph{not} be provided in the same call to \code{\link[=compare_clusterings]{compare_clusterings()}}. In such cases the scoring
function may fail entirely, e.g. if it was created with \code{type = "valid"}.
}
