# Generated by 02-duckplyr_df-methods.R
#' @rdname arrange.duckplyr_df
#' @export
arrange.duckplyr_df <- function(.data, ..., .by_group = FALSE, .locale = NULL) {
  force(.data)

  dots <- enquos(...)
  dots <- unname(dots)

  duckplyr_error <- rel_try(list(name = "arrange", x = .data, args = try_list(dots = dots, .by_group = .by_group)),
    #' @section Fallbacks:
    #' There is no DuckDB translation in `arrange.duckplyr_df()`
    #' - with `.by_group = TRUE`,
    #' - providing a value for the `.locale` argument,
    #' - providing a value for the `dplyr.legacy_locale` option.
    #'
    #' These features fall back to [dplyr::arrange()], see `vignette("fallback")` for details.
    "{.arg .by_group} = {.value TRUE} not supported" = !identical(.by_group, FALSE),
    "{.arg .locale} argument not supported" = !is.null(.locale),
    "dplyr.legacy_locale not supported" = isTRUE(getOption("dplyr.legacy_locale")),
    {
      # Translate to df before early exit, so that we can bail out for subclasses
      rel <- duckdb_rel_from_df(.data)
      if (length(dots) == 0) {
        return(.data)
      }

      dots_ascending <- handle_desc(dots)
      dots <- dots_ascending$dots
      ascending <- dots_ascending$ascending

      exprs <- rel_translate_dots(dots, .data)

      if (oo_force()) {
        rel <- oo_prep(rel, force = TRUE)
        exprs <- c(exprs, list(relexpr_reference("___row_number")))
        ascending <- c(ascending, TRUE)
      }

      rel <- rel_order(rel, exprs, ascending)

      # Don't need to sort here, already sorting by ___row_number
      if (oo_force()) {
        out_rel <- oo_restore_cols(rel)
      } else {
        out_rel <- rel
      }

      out <- duckplyr_reconstruct(out_rel, .data)
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  arrange <- dplyr$arrange.data.frame
  out <- arrange(.data, ..., .by_group = .by_group, .locale = .locale)
  return(out)

  # dplyr implementation
  dots <- enquos(...)

  if (.by_group) {
    dots <- c(quos(!!!groups(.data)), dots)
  }

  loc <- arrange_rows(.data, dots = dots, locale = .locale)
  dplyr_row_slice(.data, loc)
}

duckplyr_arrange <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- arrange(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
